if (!global.ShadowMamba) {
global.ShadowMamba = {};
        }
var sm = global.ShadowMamba;

function sm_after_effect_applied(a) {
var source = a.source_unit;
var target = a.target_unit;
var tile = a.target_tile;
var effect = a.effect;
var flags = effect.ScriptFlags;
if (flags.get("apply_sound")) {
randomSound(flags.get("apply_sound"));
}
if (flags.get("apply_message")) {
var msg = chooseFromARandomSelectString(flags.get("apply_message"));
if (source) {
if (target)
say(msg.format(source.GetName(),target.GetName()));
else if (!target) {
say(msg.format(source.GetName()));
}
}
}
if (flags.get("remove_flying")) {
if (target.Flying) {
target.Flying=false;
say(target.GetName()+" is no longer flying.");
}
}
if (flags.get("aditional_description")) {
var descriptor = flags.get("aditional_description");
if (!(target.FriendlyType.indexOf(descriptor) > -1)) {
// indexOf looks through a string and returns the index (or position) of the sought for string, or -1 if it's not there
// so if the indexOf isn't -1 here, we know that unit's FriendlyType contains the word we're looking for and should handle it somehow
target.FriendlyType = descriptor + " " + target.FriendlyType;
shared.ShareUnitUpdate(target);
}
}
}

function sm_after_effect_removed(r) {
var source = r.source_unit;
var target = r.target_unit;
var targetTile = r.target_tile;
var effect = r.effect;
var flags = effect.ScriptFlags;
if (flags.get("removal_sound")) {
randomSound(flags.get("removal_sound"));
}
if (flags.get("removal_message")) {
var msg = chooseFromARandomSelectString(flags.get("removal_message"));
if (source) {
if (target)
say(msg.format(source.GetName(),target.GetName()));
else if (!target) {
say(msg.format(source.GetName()));
}
}
}
if (flags.get("remove_flying")) {
if (unitWasOriginallyFlying(target)) {
// only needed if we're storing the fact that a unit used to be able to fly somewhere in script
target.Flying=true;
say(target.GetName()+" is now flying.");
}
}
if (flags.get("aditional_description")) {
var descriptor = flags.get("aditional_description");
target.FriendlyType = (target.FriendlyType).replace(descriptor, "");
target.FriendlyType = (target.FriendlyType).trim();
shared.ShareUnitUpdate(target);
}
}

function sm_after_effect_fizzled(f) {
var target = f.target_unit;
var tile = f.target_tile;
var effect = f.effect;
var flags = effect.ScriptFlags;
if (flags.get("remove_flying")) {
if (unitWasOriginallyFlying(target)) {
// only needed if we're storing the fact that a unit used to be able to fly somewhere in script
target.Flying=true;
say(target.GetName()+" is now flying.");
}
}
if (flags.get("aditional_description")) {
var descriptor = flags.get("aditional_description");
target.FriendlyType = (target.FriendlyType).replace(descriptor, "");
target.FriendlyType = (target.FriendlyType).trim();
shared.ShareUnitUpdate(target);
}
}

function sm_applyEffects(a) {
var source = a.source_unit;
var target = a.target_unit;
var tile = a.target_tile;
var skill = a.skill;
var item = a.item;
var flags;
if (skill)
flags = skill.ScriptFlags;
else if (item)
flags = item.ScriptFlags;
if (flags.get("apply_effects")) {
if (flags.get("apply_effects_chance")) {
var newEffects = chooseFromARandomSelectString(flags.get("apply_effects"));
var chance = flags.get("apply_effects_chance");
var math = Math.random().toFixed(2);
if (math > chance) {
}
else if (math <= chance) {
var effects = newEffects.split(",");
for (var i = 0; i < effects.length; i++) {
shared.ApplyEffect(effects[i], target, tile);
}
}
}
}
}

function sm_removeEffects(r) {
var source = r.source_unit;
var target = r.target_unit;
var tile = r.target_tile;
var skill = r.skill;
var item = r.item;
var flags;
if (skill)
flags = skill.ScriptFlags;
else if (item)
flags = item.ScriptFlags;
if (flags.get("remove_effects")) {
if (flags.get("remove_effects_chance")) {
var removeEffects = chooseFromARandomSelectString(flags.get("remove_effects"));
var chance = flags.get("remove_effects_chance");
var math = Math.random().toFixed(2);
if (math > chance) {
}
else if (math <= chance) {
var effects = removeEffects.split(",");
for (var i = 0; i < effects.length; i++) {
shared.RemoveEffect(effects[i], target, tile);
}
}
}
}
}

